import contacts

from pytest_bdd import scenario, given, when, then, parsers


class TestAddingEntries:
    def test_basic(self):
        app = contacts.Application()

        app.run("contacts add NAME 3345554433")

        assert app._contacts == [
            ("NAME", "3345554433")
        ]

    def test_surnames(self):
        app = contacts.Application()

        app.run("contacts add Mariusz Mariusz 3345554433")
        app.run("contacts add Ludwik Mariusz 3345554434")
        app.run("contacts add Księżniczka Peach 3339323323")

        assert app._contacts == [
            ("Mariusz Mariusz", "3345554433"),
            ("Ludwik Mariusz", "3345554434"),
            ("Księżniczka Peach",  "3339323323")
        ]

    def test_international_numbers(self):
        app = contacts.Application()

        app.run("contacts add NAME +393345554433")

        assert app._contacts == [
            ("NAME", "+393345554433")
        ]

    def test_invalid_strings(self):
        app = contacts.Application()

        app.run("contacts add NAME InvalidString")

        assert app._contacts == []

    def test_reload(self):
        app = contacts.Application()

        app.run("contacts add NAME 3345554433")

        assert app._contacts == [
            ("NAME", "3345554433")
        ]

        app._clear()
        app.load()

        assert app._contacts == [
            ("NAME", "3345554433")
        ]


@scenario("../acceptance/delete_contact.feature",
            "Usunięcie wpisu w książce adresowej")
def test_deleting_contacts():
    pass

@then("Moja książka adresowa będzie pusta")
def emptylist(contactbook):
    assert contactbook._contacts == []


@scenario("../acceptance/list_contacts.feature",
            "Wyświetlenie listy dodanych wpisów książki adresowej")
def test_listing_added_contacts(capsys):
    pass

@given("Mam pierwszy wpis <first>")
def have_a_first_contact(contactbook, first):
    contactbook.add(first, "000")
    return first

@given("Mam drugi wpis <second>")
def have_a_second_contact(contactbook, second):
    contactbook.add(second, "000")
    return second

@then("Dane wyjściowe zawierają listę wpisów <listed_contacts>")
def outputcontains(listed_contacts, capsys):
    expected_list = "".join([f"{c} 000\n" for c in listed_contacts.split(",")])
    out, _ = capsys.readouterr()
    assert out == expected_list


@given("Mam książkę adresową", target_fixture="contactbook")
def contactbook():
    return contacts.Application()

@given(parsers.parse("Mam wpis dotyczący użytkownika \"{contactname}\""))
def have_a_contact(contactbook, contactname):
    contactbook.add(contactname, "000")

@when(parsers.parse("Po wydaniu polecenia \"{command}\""))
def runcommand(contactbook, command):
    contactbook.run(command)
